

'M25P32 PIC Audio Serial v1.0    by Norm Carlberg    
'PIC AUDIO PLAYER FROM ST M25P32 FLASH MEMORY CHIP,
'PLAYS WAVE FILES SERIAL TRANSFERED FROM PC   NON FAT

'PROTON+ BASIC Compiler
'Compiler version 3.2.5.2

                
Device = 18F452
'COMMENT OUT ALL THE FOLLOWING @_  IN C:\Program Files\Crownhill\PDS\Inc\P18F452.lpb                 
@CONFIG_REQ    
	'	ifdef PLL@REQ ; Do we require the PLL ?
			@__config config1h, OSCS_OFF_1 & HSPLL_OSC_1
	'	else
	'		@__config CONFIG1H, OSCS_OFF_1 & HS_OSC_1
	'	endif
			@__config config2l, BOR_ON_2 & BORV_42_2 & PWRT_ON_2
	'	ifdef WATCHDOG_REQ
	'		@__config CONFIG2H, WDT_ON_2 & WDTPS_128_2
	'	else
			@__config config2h, WDT_OFF_2 & WDTPS_128_2
	'	endif
			@__config config3h, CCP2MX_ON_3
	'	ifdef DEBUG@REQ ; Do we require DEBUG ?
	'		@__config CONFIG4L, STVR_ON_4 & LVP_OFF_4 & DEBUG_ON_4
	'	else
			@__config config4l, STVR_ON_4 & LVP_OFF_4 & DEBUG_OFF_4


OPTIMISER_LEVEL = 6 
                                               
XTAL = 40      ' REQUIRES PLL  ' USE 10 MHz CRYSTAL & DECLARE: XTAL = 40

'OPTION:
'FOR 0 HSERIAL ERRORS DECLARE XTAL = 40 AND USE A 11.0592 MHz BAUD RATE CRYSTAL
'UNCOMMENT TIMER1 FOR XTAL IN USE IN DECODE_CONFIG_BYTE:  
'ALSO UNCOMMENT SPBRG IN HSERIAL DECLARE
'44.2368MHz IS A TAD OVER SPEC BUT IF NON CRITICAL AND AT ROOM TEMP "SHOULD" BE OK.
'ALL TIMINGS ARE THEN ABOUT 10% FAST

DelayMS 1000  'ALLOW POWER TO STABILIZE   

BEGINNING_OF_DIMS: 
DelayMS 200  'REQUIRED

' dVAR IS DWORD, wVAR IS WORD, yVAR IS BYTE, iVAR IS BIT, sSYMBOL IS SYMBOL

' PIC18F452
' PORTC.5 IS MICROCHIP SPI MSSP DATA OUT  
' PORTC.4 IS MICROCHIP SPI MSSP DATA IN
' PORTC.3 IS MICROCHIP SPI MSSP CLOCK

' PORTC.6 IS MICROCHIP TX
' PORTC.7 IS MICROCHIP RX

Clear 	

'*****************************************************************************
''''''''''''''''''''''SETTING FOR NUMBER OF MEMORY CHIPS''''''''''''''''''''''
Symbol sMEM_CHIPS_TOTAL = 1   ' SET 1 TO 4
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'ALSO DO SEARCH/FIND FOR  "SCALE To DA" ... 
'AND UNCOMMENT LINE CORRESPONDING TO THE DIGITAL-TO-ANALOG IN USE.
'ALSO SEE subDA  & UNCOMMENT Line CORRESPONDING To THE DIGITAL-TO-ANALOG IN USE.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'*****************************************************************************

Symbol sM25P32_MEM_MAX_BYTES_ADDRESS = (4194304 * sMEM_CHIPS_TOTAL) - 1
Symbol sM25P32_MEM_CAP_BYTES = sM25P32_MEM_MAX_BYTES_ADDRESS + 1  '+1 FOR   0 TO 

Symbol sM25P32_MEM_CS_1 = PORTA.5  ' memory chip 1  PIN 7
Symbol sM25P32_MEM_CS_2 = PORTE.0  ' memory chip 2   "
Symbol sM25P32_MEM_CS_3 = PORTE.1  ' memory chip 3   "
Symbol sM25P32_MEM_CS_4 = PORTE.2  ' memory chip 4   "

Symbol sPC_FLOW_CTS = PORTC.0   ' FLOW CONTROL 
Symbol sDSR = PORTC.1   ' HIGH = ERROR: PC RESEND,  LOW = SEND NEXT BYTE 
Symbol sDA_CS = PORTC.2 ' keep CCP1 HPWM OFF
Symbol sPLAY_BUTTON = PORTA.2  'ADD PULLUP
Symbol sFILE_INFO_BYTES = 23

''''''''' PLAY VAR'S AT TOP FOR SPEED'''''''''''
Dim dMEM_ADDRESS_READ As DWord
Dim dMEM_ADDRESS_READ2 As DWord
Dim dSOF_PLAY_ADDRESS As DWord
Dim dEOF_ADDRESS As DWord
Dim wDA_OUT As Word
Dim yDUMMY As Byte  ' RECEIVE BLANK DATA SPI
Dim iINTERRUPT_SET As Bit
Dim dLATE_FOR_PLAY_INTERRUPT As DWord
Dim yCHIP_SELECT As Byte

'ULaw compression
Dim wSAMPLE_ULAW As Word
Dim ySIGN As Byte
Dim yEXPONENT As Byte
Dim yMANTISSA As Byte
Dim yULAW_BYTE As Byte   
Dim yPBP#VAR1 As Byte SYSTEM	

' ADPCM COMPRESSION DECODE VAR'S       ' 16 BIT MAX MIN
Dim dPRED_SAMPLE_DE As DWord           ' 33270 -34572
Dim dINDEX_DE As DWord                 ' 80 -1
Dim dSTATE_PREV_SAMPLE_DE As DWord     ' 32767 -32767                             
Dim ySTATE_PREV_INDEX_DE As Byte       ' 80 0
Dim yCODE_DE As Byte   
Dim wDIFFQ_DE As Word                  ' 13372 0
Dim wSTEP_DE As Word                   ' 15289 0      
Dim wPRED_SAMPLE_DE_TEMP As Word       ' 34572 0
Dim iHIGHBYTE_LOWBYTE_DE As Bit
Dim yBYTE_2_4BITS_DE As Byte
Dim dPRED_SAMPLE_DE_2 As DWord
'''''''''''' END PLAY VAR'S '''''''''''''


Dim yARRAY65[65] As Byte   ' 64 + 1 ADDITIONAL BYTE FOR 8 BIT CRC REMAINDER
Symbol sRECORD_LED = PORTA.3  
Low sRECORD_LED
Dim dM25P32_MEM_MAX_ADDRESS_AVAIL As DWord
Dim y1 As Byte 
Dim y2 As Byte
Dim yBYTE_FROM_PC As Byte
Dim dMEM_ADDRESS_WRITE As DWord
Dim wCYCLE_IN_PROGRESS_LOOP As Word
Dim dSOF_REC As DWord
Dim dEOF_REC As DWord

Dim yEOF_BYTE2 As Byte
Dim yEOF_BYTE1 As Byte
Dim yEOF_BYTE0 As Byte
Dim ySOF_BYTE2 As Byte
Dim ySOF_BYTE1 As Byte
Dim ySOF_BYTE0 As Byte

Dim ySTATUS_REGISTER_READ As Byte    
Dim yMANUFACTURER_ID_READ As Byte
Dim wDEVICE_ID_READ As Word
Dim yARRAY_FILE_NAME16[16] As Byte
Dim iERROR As Bit
Dim dMEM_ADDRESS_WRITE_START As DWord
Dim wFILES_TOTAL As Word
Dim wFILE_COUNT As Word
Dim iFILE_COUNT_DONE As Bit
Dim wFILE_TO_READ_FILEINFO As Word
Dim dFILE_PLAY As DWord
dFILE_PLAY = -1
Dim iPLAY_ENABLED As Bit
Dim wIN_PROG_FILE_TO_PLAY As Word
Dim iIN_PROGRAM_FILE_PLAY_SET As Bit
Dim iMEM_MAXED_OUT_SET As Bit
Dim yCONFIG As Byte
Dim yCONFIG_TIMED_OUT As Byte
Dim yFILE_TYPE As Byte
Dim ySAMPLE_RATE As Byte
Dim dTimerPreload As DWord
Dim wTIMER1 As TMR1L.Word      ' access 16 bits of TMR1
Dim yFILE_FILE_NAME_TIMED_OUT_SET As Byte
Dim yFILE_DATA As Byte
Dim iPLAY_ALL_SET As Bit
Dim yCRC As Byte
Dim wTEMP As Word
Dim iREC_TO_CAPACITY_SET As Bit

'HSERIN
Dim ySERIAL_BUFFER_STOP_PT As Byte
Dim yBUFFER_PT As Byte
Dim yINC_0_to_63 As Byte
Dim dSERIAL_IN_TIMED_OUT_COUNT As DWord
Dim iSERIAL_IN_TIMED_OUT_SET As Bit
Dim yINC_0_to_3 As Byte
Dim yBYTE_FROM_PC2 As Byte

Dim iSTORE_FILEINFO_DONE As Bit
Dim yNOHOLD_COUNT As Byte
Dim yHOLD_COUNT As Byte
Dim wNOPRESS_COUNT As Word
Dim iERASE_SET As Bit
Dim dBYTES_REMAINING As DWord
Dim yDOT_COUNT As Byte
Dim dDUMMY_CROSSING_BANK_ERROR As DWord
Dim dMEMORY_USED_PER_CENT As DWord
Dim dBYTES_REMAINING_PER_CENT As DWord
Dim wCOUNT As Word
Dim yREC_LED_COUNT As Byte

END_DIMS_BOOKMARK:


'***********************************************
Declare HSERIAL_BAUD 115200 
RCSTA.7 = 1   ' SERIAL PORT ENABLED
RCSTA.4 = 1   ' ENABLES RECEIVER                   
TXSTA.2 = 1   ' BRGH = BIT 2 OF TXSTA  1 = HIGH SPEED  %00100110
TXSTA.4 = 0   ' SYNC = BIT 4 OF TXSTA  0 = ASYNCHRONOUS 'SYNC IS BIT 4 OF TXSTA
TXSTA.5 = 1   ' TX ENABLE
SPBRG = 21  ' 40 MHz       10 MHz CRYSTAL
'SPBRG = 23  ' 44.2368 MHz  11.0592 MHz BAUD RATE CRYSTAL FOR 0 TIMING ERRORS

'***********************************************
'AD   NOT IN USE
ADCON0 = %00000001  'xxxxxxx1 ENABLES AD   '000xxxxx AN0
ADCON1 = %00001110  'xxxx1110 AN0 ANALOG   '
 
'***********************************************
TRISA.5 = 0         
TRISA.4 = 0
TRISA.3 = 0
TRISA.2 = 1   ' PLAY BUTTON
TRISA.1 = 0   
TRISA.0 = 1   ' NOT USED
TRISB=%00000000
TRISC=%10010000 'xxx1xxxx MSSP SPI micro data in    'C.7 HSERIN
TRISD=%00000000
TRISE.2 = 0
TRISE.1 = 0
TRISE.0 = 0

'***********************************************
' MSSP = MASTER SYNCHROUS SERIAL PORT MODULE ' SPI Port Setup
SSPSTAT = %01000000  ' %X1XXXXXX  1 = transmitted On rising Clock Edge
'SSPCON1 = %00100010 ' SLOW           '  %xxx0xxxx 0 = CLK IDLE LOW
'SSPCON1 = %00100001 ' MED            '  %xx1xxxxx 1 = ENABLES SCK SDO & SDI  
SSPCON1 = %00100000  ' FAST           '  %xxxxxXXX XXX  CLOCK   SPEED SET
                             
'***********************************************
'INTERRUPT REGISTER'S
RCON.7 = 0   ' 0 DISABLES PRIORITY LEVELS ON INTERRUPTS (16F COMPATABILITY)

T1CON = %10000000	'BITS XX OF %10XX0001 = 00 = 1:1 PRESCALE
                    'T1CON.0 = 0   ' 0 = TIMER 1 OFF							
PIE1 = %00000001    'enable TMR1 overflow interrupt
INTCON = %11000000  'enable global and peripheral interrupts 

ON_HARDWARE_INTERRUPT GoTo HARDWARE_INTERRUPT_ROUTINE  ' 425 OK  ' 4520 NOT OK


GoTo START   ' JUMP PAST SUBROUTINES


'***********************************************
'''''''''''''' ASSEMBLY HARDWARE TMR 1 INTERRUPT ''''''''''''
HARDWARE_INTERRUPT_ROUTINE:

iINTERRUPT_SET = 1 

' clear interrupt flag and exit...   
bcf PIR1,0 
wTIMER1 = dTimerPreload

retfie fast   
'''''''''''' END ASSEMBLY HARDWARE TMR 1 INTERRUPT ''''''''''


'***********************************************
READ_ID:  ' M25P32 

yCHIP_SELECT = 1
LOOP_MEM_TEST:

y2 = 0
WAKEUP_REPEAT:

GoSub subLOW_CS
   
SSPBUF = $9F ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF

'SHIn  sDATA_UCHIP_IN, sCLK, msbpost_h,[yMANUFACTURER_ID_READ\8]   
SSPBUF = yDUMMY ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yMANUFACTURER_ID_READ = SSPBUF

'SHIn  sDATA_UCHIP_IN, sCLK, msbpost_h,[wDEVICE_ID_READ\16]
SSPBUF = yDUMMY ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
wDEVICE_ID_READ.HighByte = SSPBUF

SSPBUF = yDUMMY ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
wDEVICE_ID_READ.LowByte = SSPBUF

GoSub subHI_CS 
    
'HSEROUT["yMANUFACTURER_ID_READ SHOULD = 00100000",13]
'HSerOut["yMANUFACTURER_ID_READ =              ",BIN8 yMANUFACTURER_ID_READ,13]
    
'HSerOut["wDEVICE_ID_READ SHOULD = 0010000000010110",13]
'HSerOut["wDEVICE_ID_READ =              ",BIN16 wDEVICE_ID_READ,13]

''''''''''''''''''''''''''''''          
' TO TEST MEMORY TEST:    
' DISCONECT M25P32 DATA OUT PIN 8
'''''''''''''''''''''''''''''                                       

If yMANUFACTURER_ID_READ = %00100000 And wDEVICE_ID_READ = %0010000000010110 Then
HSerOut[" TEST MEMORY CHIP ",Dec yCHIP_SELECT," OF ",Dec sMEM_CHIPS_TOTAL," OK",13]
    If yCHIP_SELECT < sMEM_CHIPS_TOTAL Then
    Inc yCHIP_SELECT
    GoSub subREAD_STATUS_REGISTER
    GoTo LOOP_MEM_TEST
    EndIf                                 
GoTo RETURN_FROM_READ_ID 

Else
Inc y2       ' WAKEUP MEMORY CHIP
    If y2 < 6 Then
    GoTo WAKEUP_REPEAT
    EndIf
HSerOut[" MEMORY ",Dec yCHIP_SELECT," TEST FAIL, #@%*@&)#%#@%*@&%#%#@%*@&#%",13]
GoTo MEM_FAIL
EndIf
 
 
'***********************************************
MEM_FAIL: 

HSerOut[" RESET MICROCHIP  OR  PRESS DELETE to ERASE MEMORY CHIP",13]

yBYTE_FROM_PC = 0

y1 = 0
MEM_FAIL_LOOP:
   
High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 1000,EXIT_HSERIN_MEM_FAIL,[yBYTE_FROM_PC]   
EXIT_HSERIN_MEM_FAIL:
Low sPC_FLOW_CTS       ' BLOCK  PC To Send 
    
If yBYTE_FROM_PC = 68 Then  'D FOR DELETE RECEIVED
HSerOut[13," RECEIVED ERASE CMD",13]    
GoTo BULK_ERASE
EndIf

If yBYTE_FROM_PC = 210 Then
HSerOut[13," RECEIVED RESET CMD",13]
DelayMS 100
reset
EndIf 


Inc y1
If y1 = 70 Then
y1 = 0
HSerOut["/",13]
Else
HSerOut["/"]
EndIf

GoTo MEM_FAIL_LOOP    



'***********************************************
subINSTRUCTIONS_WRITE_ENABLE:  

GoSub subLOW_CS

SSPBUF = $06 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF

GoSub subHI_CS 

GoSub subREAD_STATUS_REGISTER
Return
               
               
'***********************************************
subREAD_STATUS_REGISTER:                         

GoSub subLOW_CS
CYCLE_IN_PROGRESS:

SSPBUF = $05 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF

SSPBUF = yDUMMY ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
ySTATUS_REGISTER_READ = SSPBUF
    
If ySTATUS_REGISTER_READ.0 = 0 Then  ' MEM CHIP COMPLETED TASK

GoSub subHI_CS 
                                                               
Return  ' COMPLETE

Else   ' MEM CHIP NOT COMPLETED TASK
DelayUS 40
'DELAYUS 80

Inc wCYCLE_IN_PROGRESS_LOOP
If wCYCLE_IN_PROGRESS_LOOP = 500 Or wCYCLE_IN_PROGRESS_LOOP = 1000 Then
    If iERASE_SET = 1 Then
    Toggle sPC_FLOW_CTS
    EndIf
EndIf    

If wCYCLE_IN_PROGRESS_LOOP = 1000 Then
wCYCLE_IN_PROGRESS_LOOP = 0
    Inc yDOT_COUNT
    If yDOT_COUNT > 85 Then
    yDOT_COUNT = 0
    HSerOut [".",13]
    Else
    HSerOut ["."]
    EndIf
    
GoSub subHI_CS 

DelayUS 20
EndIf

GoSub subLOW_CS                              
GoTo CYCLE_IN_PROGRESS
EndIf


'***********************************************
MEM_CHIP_RECORD:

' RECORD TO NEXT ADDRESS ON MEM CHIP
wFILE_TO_READ_FILEINFO = wFILES_TOTAL
GoSub subREAD_STORED_FILEINFO

dMEM_ADDRESS_WRITE = dEOF_ADDRESS + 1   

' LATER DETERMINE IF ANY DATA WRITTEN   VALID NEW FILE
dMEM_ADDRESS_WRITE_START = dMEM_ADDRESS_WRITE
dSOF_REC = dMEM_ADDRESS_WRITE
   
' TO START ADDRESS AT BEGINNIG OF SECTOR (NOT NECESSARILY REC START ADDRESS)
wTEMP = dMEM_ADDRESS_WRITE / 256    'wTEMP A WORD   NO DECIMAL POINT
dMEM_ADDRESS_WRITE = wTEMP * 256 

HSerOut [" RECORDING NEW FILE ",Dec wFILES_TOTAL + 1,13] 

''''''''''RECEIVE CONFIG Byte (FIRST BYTE PC SEND)'''''''''''''' 
RECEIVE_CONFIG_TIMED_OUT:    
Low sPC_FLOW_CTS   ' BLOCK  PC To Send
    Inc yCONFIG_TIMED_OUT
    If yCONFIG_TIMED_OUT < 50 Then   '< 23
        If yCONFIG_TIMED_OUT > 2 Then 
        EndIf
    Else 
    HSerOut [13," RECEIVE_CONFIG_TIMED_OUT",13]
    GoTo BEGINNING_OF_DIMS                    
    EndIf
High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 50,RECEIVE_CONFIG_TIMED_OUT,[yCONFIG]   ' RECEIVE DATA
Low sPC_FLOW_CTS   ' BLOCK  PC To Send         
''''''''''END  RECEIVE CONFIG Byte (FIRST BYTE SENT)'''''''''''''' 


''''''''''RECEIVE FILE NAME Byte's (2nd-17th BYTES PC SEND)''''''''''''''
yFILE_FILE_NAME_TIMED_OUT_SET = 0

DelayMS 100
For y1 = 0 To 15

vFILE_NAME_TIMED_OUT:
Low sPC_FLOW_CTS    ' BLOCK  PC To Send

    Inc yFILE_FILE_NAME_TIMED_OUT_SET
    If yFILE_FILE_NAME_TIMED_OUT_SET <= 22 Then
        If yFILE_FILE_NAME_TIMED_OUT_SET > 2 Then
        HSerOut [" FILE-NAME-TIMEDOUT-",Dec yFILE_FILE_NAME_TIMED_OUT_SET - 2,"  "]  
        EndIf
    Else 
    HSerOut [" RECEIVE FILE NAME FROM PC TIMED OUT",13]
    GoTo BEGINNING_OF_DIMS  
    EndIf
       
High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 50,vFILE_NAME_TIMED_OUT,[yFILE_DATA]   ' RECEIVE DATA
Low sPC_FLOW_CTS   ' BLOCK  PC To Send

yARRAY_FILE_NAME16[y1] = yFILE_DATA
yFILE_FILE_NAME_TIMED_OUT_SET = 0
Next

HSerOut [13," FILE NAME: ["]
For y1 = 0 To 15
HSerOut [yARRAY_FILE_NAME16[y1]]
Next
HSerOut ["] ",13]
''''''''''END  RECEIVE FILE NAME Byte's (2nd-17th BYTES PC SEND)''''''''''''''

iREC_TO_CAPACITY_SET = 0 
ySERIAL_BUFFER_STOP_PT = 63 
yBUFFER_PT = 0 
High sDSR

REC_LOOP: '[[[[[[[[[[[[[[[
 
Select dMEM_ADDRESS_WRITE.BYTE2
Case < 64
yCHIP_SELECT = 1
Case < 128
yCHIP_SELECT = 2
Case < 192
yCHIP_SELECT = 3
Case <= 255
yCHIP_SELECT = 4
EndSelect
  
GoSub subINSTRUCTIONS_WRITE_ENABLE

GoSub subLOW_CS

GoSub subWRITE_BYTES_ADDRESS  'NOW dMEM_ADDRESS_WRITE.BYTE2

yINC_0_to_63 = 0                    

LOOP_0_to_3_LABEL1:  'If yINC_0_to_3 < 4 Then

LOOP_0_to_63_LABEL1: 'If yINC_0_to_63 < 64 Then


If dMEM_ADDRESS_WRITE < dMEM_ADDRESS_WRITE_START Then
    SSPBUF = %11111111 ' RECORD TO MEMORY CHIP 'DOES NOT CHANGE 0's TO 1's UNLESS ERASE
    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE     ' NO DATA CHANGE
    yDUMMY = SSPBUF
    
   
    Inc dMEM_ADDRESS_WRITE   
    Inc yINC_0_to_63

Else
    
    If yBUFFER_PT = 0 And iSERIAL_IN_TIMED_OUT_SET = 0 And iREC_TO_CAPACITY_SET = 0 Then
    
    ''''' RECEIVE Data BYTES INTO ARRAY ''''' 
    RESEND:
    dSERIAL_IN_TIMED_OUT_COUNT = 0
    y2 = 0
        
    RECEIVE_FROM_PC_TIMED_OUT2:  ' HSERIN TIMEOUT LOOP
    Inc dSERIAL_IN_TIMED_OUT_COUNT
        If dSERIAL_IN_TIMED_OUT_COUNT > 40 Then  '40 * 50MS = 2000 ' 2 SEC TIMEOUT DATA FROM PC  DATA
            If dMEM_ADDRESS_WRITE = dMEM_ADDRESS_WRITE_START Then    
            GoSub subHI_CS  
            DelayMS 20
               
            HSerOut["*** NO FILE CREATED: GoTo BEGINNING_OF_DIMS ***",13]
            GoSub subREAD_STATUS_REGISTER
            GoTo BEGINNING_OF_DIMS
            EndIf    
        iSERIAL_IN_TIMED_OUT_SET = 1
        dEOF_REC = dMEM_ADDRESS_WRITE - 1
        ySERIAL_BUFFER_STOP_PT = 63 
        
        GoTo EXIT_HSERIN2   
        EndIf 
        

        LOOP_0_To_64:
        
        High sPC_FLOW_CTS       ' Clear  PC To Send ENTIRE PACKET
        'PC ONLY LOOKS FOR sPC_FLOW_CTS FOR FIRST BYTE SEND
        HSerIn 50,RECEIVE_FROM_PC_TIMED_OUT2,[yBYTE_FROM_PC]   ' RECEIVE DATA
        Low sDSR
        Low sPC_FLOW_CTS        ' BLOCK  PC FROM SENDING NEXT PACKET


        dSERIAL_IN_TIMED_OUT_COUNT = 0
    
        yARRAY65[y2] = yBYTE_FROM_PC
        
        Inc y2
  If y2 < 65 Then
  GoTo LOOP_0_To_64
  EndIf    
  ''''' END RECEIVE Data BYTES INTO ARRAY '''''


           
        
    
'''''''''''''''''''''''''''''''''''''''''  

'      '''SIMULATE ERROR
'    Inc wCOUNT   
'    If wCOUNT = 1000 Then
'    yARRAY65[4] = yARRAY65[4] + 1 
'    HSerOut["SIM-ERR, "]
'    wCOUNT = 0
'    EndIf      
   
'    If wCOUNT >= 2000 Then  'error out 
'    yARRAY65[4] = yARRAY65[34] + 1     
'    EndIf
 

    ''''' CRC ERROR CHECK '''''
    yCRC = 0                                         
    y2 = 0
    Repeat     
      wTEMP = yCRC ^ yARRAY65[y2]
      yCRC = LRead crc8 + wTEMP
    Inc y2
    Until y2 = 64           
 
    If yCRC <> yARRAY65[64]  Then  
    Low sDSR
    HSerOut ["Er,"]
    
    iERROR = 1
    GoTo RESEND
    Else

    High sDSR 'NO CRC ERROR
       If iERROR = 1 Then
       iERROR = 0
       HSerOut [" OK",13]
       EndIf
    EndIf
    ''''' END CRC ERROR CHECK '''''

               
    dSERIAL_IN_TIMED_OUT_COUNT = 0    
    yBUFFER_PT = 0
     
    EndIf  'If yBUFFER_PT = 0 And iSERIAL_IN_TIMED_OUT_SET = 0 And iREC_TO_CAPACITY_SET = 0 Then
    EXIT_HSERIN2:  ' HSERIN TIMED-OUT COUNT MAXED
          
      
    yBYTE_FROM_PC2 = yARRAY65[yBUFFER_PT]  
      
                   
  
          
    If iREC_TO_CAPACITY_SET = 1 Or iSERIAL_IN_TIMED_OUT_SET = 1 Then
    'IF OVER CAPACITY OVERWRITE WITH $FF's OR %11111111's WHICH IS OK ...
    'BECAUSE M25P32 CANNOT CHANGE 0's TO 1's EXCEPT BY ERASE.                              
    SSPBUF = $FF   ' RECORD TO MEMORY CHIP
    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
    yDUMMY = SSPBUF
    
    Else
    SSPBUF = yBYTE_FROM_PC2   ' RECORD TO MEMORY CHIP    'DATA
    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
    yDUMMY = SSPBUF            
    EndIf  
      
    If iREC_TO_CAPACITY_SET = 0 Then       
        If dMEM_ADDRESS_WRITE >= dM25P32_MEM_MAX_ADDRESS_AVAIL Then                                            
        dEOF_REC = dMEM_ADDRESS_WRITE
        ySERIAL_BUFFER_STOP_PT = yBUFFER_PT
        iREC_TO_CAPACITY_SET = 1   'RECORDING IN LAST AVAIL PAGE
        EndIf                      'MAY OR MAY NOT OF COMPLETED FILE
    EndIf                          'COULD BE COMPLETING PAGE WITH OVERWRITE OF $FF's
    
    
    Inc dMEM_ADDRESS_WRITE   
    
    Inc yINC_0_to_63
    Inc yBUFFER_PT
    
    If yBUFFER_PT = 64 Then
    yBUFFER_PT = 0
    EndIf
       
EndIf 

If yINC_0_to_63 < 64 Then  
GoTo LOOP_0_to_63_LABEL1
EndIf                                    
yINC_0_to_63 = 0 
  
Inc yINC_0_to_3 
If yINC_0_to_3 < 4 Then
GoTo LOOP_0_to_3_LABEL1
EndIf 

yINC_0_to_3 = 0
 
' 256 BYTE PAGE COMPLETED
    
GoSub subHI_CS  

Inc yREC_LED_COUNT
If yREC_LED_COUNT = 3 Then
yREC_LED_COUNT = 0
Toggle sRECORD_LED '''''''''''' AT PAGE (256 BYTES)  16,384 PAGES ST M25P32
EndIf

GoSub subREAD_STATUS_REGISTER

If iREC_TO_CAPACITY_SET = 0 And iSERIAL_IN_TIMED_OUT_SET = 0 Then    
GoTo REC_LOOP   ' KEEP RECORDING  ']]]]]]]]]]]]]]

Else 



For y1 = ySERIAL_BUFFER_STOP_PT To 0 Step - 1
If yARRAY65[y1] = 255 Then
Dec dEOF_REC   ' BACKTRACK EOF TRAILING $FF's
Else
Break
EndIf
Next

    If iREC_TO_CAPACITY_SET = 1 Then
            
        If dEOF_REC = dM25P32_MEM_MAX_ADDRESS_AVAIL Then
        HSerOut [13," **** END RECORD, CHIP CAPACITY ****",13]
        HSerOut[" MEM MAXED OUT AT ",Dec dEOF_REC,13]
        Else
        HSerOut[13," REC ENDED IN LAST AVAIL SECTOR AT ",Dec dEOF_REC,13]
        EndIf
        
               
        GoSub subREAD_STATUS_REGISTER
        GoSub subWRITE_STORED_FILEINFO
        GoSub subREAD_STATUS_REGISTER        
        HSerOut [" **** DELAY 4 SEC TO TIMEOUT PC ****",13]
        HSerOut[" GoTo BEGINNING_OF_DIMS",13]
        DelayMS 4000       ' DELAY 2x LONGER THAN PC TIMEOUT 
        GoTo BEGINNING_OF_DIMS
        
    Else 'SAVES END OF PAGE ADDRESS WHEN iSERIAL_IN_TIMED_OUT_SET = 1 
    
        GoSub subREAD_STATUS_REGISTER
        GoSub subWRITE_STORED_FILEINFO
        GoSub subREAD_STATUS_REGISTER
        HSerOut[13," RECORD COMPLETE AT ",Dec dEOF_REC,13]
        DelayMS 1000  
        GoTo BEGINNING_OF_DIMS
        
    EndIf 

EndIf
'NEVER REACHES HERE
'END OF MEM_CHIP_RECORD


'***********************************************
crc8:
LData 0 , 94 , 188 , 226 , 97 , 63 , 221 , 131 , 194 , 156
LData 126 , 32 , 163 , 253 , 31 , 65 , 157 , 195 , 33 , 127
LData 252 , 162 , 64 , 30 , 95 , 1 , 227 , 189 , 62 , 96
LData 130 , 220 , 35 , 125 , 159 , 193 , 66 , 28 , 254 , 160
LData 225 , 191 , 93 , 3 , 128 , 222 , 60 , 98 , 190 , 224
LData 2 , 92 , 223 , 129 , 99 , 61 , 124 , 34 , 192 , 158
LData 29 , 67 , 161 , 255 , 70 , 24 , 250 , 164 , 39 , 121
LData 155 , 197 , 132 , 218 , 56 , 102 , 229 , 187 , 89 , 7
LData 219 , 133 , 103 , 57 , 186 , 228 , 6 , 88 , 25 , 71
LData 165 , 251 , 120 , 38 , 196 , 154 , 101 , 59 , 217 , 135
LData 4 , 90 , 184 , 230 , 167 , 249 , 27 , 69 , 198 , 152
LData 122 , 36 , 248 , 166 , 68 , 26 , 153 , 199 , 37 , 123
LData 58 , 100 , 134 , 216 , 91 , 5 , 231 , 185 , 140 , 210
LData 48 , 110 , 237 , 179 , 81 , 15 , 78 , 16 , 242 , 172
LData 47 , 113 , 147 , 205 , 17 , 79 , 173 , 243 , 112 , 46
LData 204 , 146 , 211 , 141 , 111 , 49 , 178 , 236 , 14 , 80
LData 175 , 241 , 19 , 77 , 206 , 144 , 114 , 44 , 109 , 51
LData 209 , 143 , 12 , 82 , 176 , 238 , 50 , 108 , 142 , 208
LData 83 , 13 , 239 , 177 , 240 , 174 , 76 , 18 , 145 , 207
LData 45 , 115 , 202 , 148 , 118 , 40 , 171 , 245 , 23 , 73
LData 8 , 86 , 180 , 234 , 105 , 55 , 213 , 139 , 87 , 9
LData 235 , 181 , 54 , 104 , 138 , 212 , 149 , 203 , 41 , 119
LData 244 , 170 , 72 , 22 , 233 , 183 , 85 , 11 , 136 , 214
LData 52 , 106 , 43 , 117 , 151 , 201 , 74 , 20 , 246 , 168
LData 116 , 42 , 200 , 150 , 21 , 75 , 169 , 247 , 182 , 232
LData 10 , 84 , 215 , 137 , 107 , 53
 
 
'***********************************************
DECODE_CONFIG_BYTE:

If yCONFIG = 0 Then  ' DATA FILE
    yFILE_TYPE = 4  
    HSerOut[" DATA FILE,  NO INTERRUPT,  DATA SIZE: 8 Bit",13] 
    
    Else   ' WAVE FILE
                              
    yFILE_TYPE = yCONFIG & %00000011 ' mask the 6 MSB
       
    Select yFILE_TYPE
    Case 0    '00
    HSerOut[" SAMPLE SIZE: ADPCM COMPRESSION 16 TO 4 BITS",13]
    
    Case 1    '01
    HSerOut[" SAMPLE SIZE: 8 BIT",13]
    
    Case 2    '10
    HSerOut[" SAMPLE SIZE: Ulaw COMPRESSION 16 TO 8 BITS",13]
    
    Case 3    '11    
    HSerOut[" SAMPLE SIZE: 16 BIT",13]
    EndSelect
    
    ySAMPLE_RATE = yCONFIG >> 2  ' THE 6 MSB
    HSerOut[" SAMPLE_RATE: ",Dec ySAMPLE_RATE,"K",13]
    
    If ySAMPLE_RATE < 6 Or ySAMPLE_RATE > 44 Then
    HSerOut[" ySAMPLE_RATE <6 OR >44    RESTART ",13]
    GoTo BEGINNING_OF_DIMS
    EndIf
    
       ''''''''''''''''''''''''''''''''''''''''''''''
        'TIMER 1   16BIT PIC18F452 40MHz  
        '40,000,000 (40 MHz) / 4 = 10,000,000
        '10,000,000 / desired Interrupt frequency = TICKS
        'FOR 16 BIT TIMER 65536 - TICKS   THEN ADD FOR NUMBER OF INSTRUCTIONS IN INTERRUPT
        
         T1CON.0 = 0   ' 0 = TIMER 1 OFF
        'dTimerPreload = 10000/ySAMPLE_RATE
        dTimerPreload = 1000000/(ySAMPLE_RATE)  ' 10000 * 100
        dTimerPreload = dTimerPreload + 55      ' ROUND UP
        dTimerPreload = dTimerPreload / 100     ' 10000 / 100
        dTimerPreload = 65536 - dTimerPreload + 4
                 
         
         
         'TIMER 1   16BIT PIC18F452 44.2368MHz BAUD RATE CRYSTAL  0 HSERIAL TIMING ERRORS 
        '44.2368MHz IS A TAD OVER SPEC BUT IF NON CRITICAL AND AT ROOM TEMP "SHOULD" BE OK.
        '44,236,800 (40 MHz) / 4 = 11,059,200
        '11,059,200 / desired Interrupt frequency = TICKS
        'FOR 16 BIT TIMER 65536 - TICKS   THEN ADD FOR NUMBER OF INSTRUCTIONS IN INTERRUPT
                
'        T1CON.0 = 0   ' 0 = TIMER 1 OFF
'        'dTimerPreload = 11059/ySAMPLE_RATE
'        dTimerPreload = 1105920/(ySAMPLE_RATE)  ' 10000 * 100
'        dTimerPreload = dTimerPreload + 55      ' ROUND UP
'        dTimerPreload = dTimerPreload / 100     ' 10000 / 100
'        dTimerPreload = 65536 - dTimerPreload + 4
        
        ''''''''''''''''''''''''''''''''''''''''''''''
        
EndIf
GoTo RETURN_FROM_DECODE_CONFIG_BYTE


'***********************************************
subLOW_CS:

Select yCHIP_SELECT
Case 1 
Low sM25P32_MEM_CS_1 
Case 2 
Low sM25P32_MEM_CS_2
Case 3 
Low sM25P32_MEM_CS_3
Case 4 
Low sM25P32_MEM_CS_4    
EndSelect    

Return


'***********************************************
subHI_CS:

High sM25P32_MEM_CS_1
High sM25P32_MEM_CS_2
High sM25P32_MEM_CS_3
High sM25P32_MEM_CS_4    

Return


'***********************************************
MEM_CHIP_PLAY_ADPCM:  

iHIGHBYTE_LOWBYTE_DE = 0
iINTERRUPT_SET = 0
dSTATE_PREV_SAMPLE_DE = 0
ySTATE_PREV_INDEX_DE = 0
 
Repeat '[[[[[[[[[[[[ 


If iHIGHBYTE_LOWBYTE_DE = 1 Then 
Dec dMEM_ADDRESS_READ  ' UNDO INC 

GoSub subDECODE_ADPCM ' DECODE UPPER 4 BITS   

GoTo SKIP_MEM_READ_4_BIT_ADPCM  ' SKIP MEM READ
EndIf

GoSub subCASCADE
                                           
GoSub subREAD_BYTES_ADDRESS

If iHIGHBYTE_LOWBYTE_DE = 0 Then 
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE         
yBYTE_2_4BITS_DE = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP
           
' MEMORY READ COMPLETE 
GoSub subHI_CS 
           
GoSub subDECODE_ADPCM ' DECODE LOWER 4 BITS 
                                    
EndIf
           
SKIP_MEM_READ_4_BIT_ADPCM:

' UNCOMMENT LINE FOR DA(DIGITAL TO ANALOG) BIT SIZE IN USE          
' ADPCM 4bit to 16bit DEcompressed
wDA_OUT = wDA_OUT / 256  'DOWNSAMPLE 16 BIT TO  8 BIT DA
'0000                                16 BIT TO 16 BIT DA

GoSub subWAIT_INTERRUPT
 
'GoSub subDA
'OR                                        
If dMEM_ADDRESS_READ < dEOF_ADDRESS - 100 Then '-50 ELIMINATE POP ON MICROSOFT SAM 
GoSub subDA                                        'ALSO MUST TRIM FLAT END OF FILE
EndIf
    
wDA_OUT = 0  

If sPLAY_BUTTON = 0 Then
DelayMS 5    'DEBOUNCE
    If sPLAY_BUTTON = 0 Then  
    While sPLAY_BUTTON = 0 : Wend
    GoTo STOP_PLAY
    EndIf
EndIf

Toggle sPC_FLOW_CTS  ' PC DETECT PIC

Inc dMEM_ADDRESS_READ
Until dMEM_ADDRESS_READ > dEOF_ADDRESS  ']]]]]]]]]]]]]

If iPLAY_ALL_SET = 1 And dFILE_PLAY < wFILES_TOTAL Then  'PLAY ALL
GoTo PLAY_ALL_NEXT    
EndIf
    
GoTo STOP_PLAY
'DONE MEM_CHIP_PLAY_ADPCM:


'***********************************************
INDEX_TABLE:  ' for subDECODE_ADPCM       
LData As DWord -1, -1, -1, -1, 2, 4, 6, 8,_
               -1, -1, -1, -1, 2, 4, 6, 8               

STEPSIZE_TABLE:      
LData As DWord  7, 8, 9, 10, 11, 12, 13, 14, 16, 17,_
                19, 21, 23, 25, 28, 31, 34, 37, 41, 45,_
                50, 55, 60, 66, 73, 80, 88, 97, 107, 118,_
                130, 143, 157, 173, 190, 209, 230, 253, 279, 307,_
                337, 371, 408, 449, 494, 544, 598, 658, 724, 796,_
                876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066,_
                2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358,_
                5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899,_
                15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, 32767

'***********************************************
subDECODE_ADPCM:

' 2 COMPRESSED 4BIT SAMPLES FROM ONE BYTE VAR
If iHIGHBYTE_LOWBYTE_DE = 0 Then  ' FIRST:   DECODE UPPER 4 BITS TO BYTE
iHIGHBYTE_LOWBYTE_DE = 1         
yCODE_DE = yBYTE_2_4BITS_DE >> 4
Else
iHIGHBYTE_LOWBYTE_DE = 0  
yCODE_DE = yBYTE_2_4BITS_DE << 4  ' 2nD:   DECODE LOWER 4 BITS TO BYTE 
yCODE_DE = yCODE_DE >> 4
EndIf

dPRED_SAMPLE_DE = dSTATE_PREV_SAMPLE_DE
dINDEX_DE = ySTATE_PREV_INDEX_DE
wSTEP_DE = LRead32 STEPSIZE_TABLE[dINDEX_DE] 
wDIFFQ_DE = wSTEP_DE >> 3

If (yCODE_DE & 4) = 4 Then
wDIFFQ_DE = wDIFFQ_DE + wSTEP_DE
EndIf

If (yCODE_DE & 2) = 2 Then
wDIFFQ_DE = wDIFFQ_DE + (wSTEP_DE >> 1)
EndIf

If (yCODE_DE & 1) = 1 Then
wDIFFQ_DE = wDIFFQ_DE + (wSTEP_DE >> 2)
EndIf
         
If (yCODE_DE & 8) = 8 Then
dPRED_SAMPLE_DE = dPRED_SAMPLE_DE - wDIFFQ_DE
Else
dPRED_SAMPLE_DE = dPRED_SAMPLE_DE + wDIFFQ_DE
EndIf

If dPRED_SAMPLE_DE > 32767 Then
dPRED_SAMPLE_DE = 32767  
EndIf

If dPRED_SAMPLE_DE < -32767 Then
dPRED_SAMPLE_DE = -32767  
EndIf

dPRED_SAMPLE_DE_2 = dPRED_SAMPLE_DE + 32767   ' TO 0 TO 65534

wDA_OUT = dPRED_SAMPLE_DE_2

dINDEX_DE = dINDEX_DE + LRead32 INDEX_TABLE[yCODE_DE]

If dINDEX_DE < 0 Then
dINDEX_DE = 0
EndIf

If dINDEX_DE > 88 Then
dINDEX_DE = 88 
EndIf 

dSTATE_PREV_SAMPLE_DE = dPRED_SAMPLE_DE
ySTATE_PREV_INDEX_DE = dINDEX_DE 

Return
'subDECODE_ADPCM: END


'***********************************************
MEM_CHIP_PLAY_8BIT: 

iINTERRUPT_SET = 0

Repeat   '[[[[[[[[[[

GoSub subCASCADE
                     
GoSub subREAD_BYTES_ADDRESS                      

SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE        
wDA_OUT = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP 

GoSub subHI_CS 
                                                              
' UNCOMMENT LINE FOR DA(DIGITAL TO ANALOG) BIT SIZE IN USE      
' SCALE TO DA   UPSAMPLE DOES NOT INCREASE RESOLUTION     
'0000                                8 BIT TO  8 BIT DA
'wDA_OUT = wDA_OUT * 256  ' UPSAMPLE 8 BIT TO 16 BIT DA

GoSub subWAIT_INTERRUPT

'GoSub subDA
'OR                                         
If dMEM_ADDRESS_READ < dEOF_ADDRESS - 500 Then '-500 ELIMINATE POP ON MICROSOFT SAM 
GoSub subDA                                         'ALSO MUST TRIM FLAT END OF FILE
EndIf     

If sPLAY_BUTTON = 0 Then
DelayMS 5    'DEBOUNCE
    If sPLAY_BUTTON = 0 Then
    While sPLAY_BUTTON = 0 : Wend
    GoTo STOP_PLAY
    EndIf
EndIf

Toggle sPC_FLOW_CTS  ' PC DETECT PIC

Inc dMEM_ADDRESS_READ
Until dMEM_ADDRESS_READ > dEOF_ADDRESS  ']]]]]]]]]

If iPLAY_ALL_SET = 1 And dFILE_PLAY < wFILES_TOTAL Then  'PLAY ALL
GoTo PLAY_ALL_NEXT    
EndIf
    
GoTo STOP_PLAY
' DONE MEM_CHIP_PLAY_8BIT:



exp_lut2: LData As Word 0,132,396,924,1980,4092,8316,16764	
'***********************************************
MEM_CHIP_PLAY_ULAW:  

iINTERRUPT_SET = 0       
 
Repeat    '[[[[[[[[[[[ 

GoSub subCASCADE

GoSub subREAD_BYTES_ADDRESS                                           
         
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE       
yULAW_BYTE = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP

GoSub subHI_CS 

' ULAW Decoder
' Input		: 8-bit ulaw sample held in yULAW_BYTE
' Output	: Signed 16-bit linear sample in wSAMPLE_ULAW
yEXPONENT = yULAW_BYTE >> 4					' Extract the upper 4-bits of ULAW_BYTE
yEXPONENT = yEXPONENT & 7					' Remove the sign bit
yMANTISSA = yULAW_BYTE & $0F				' Extract the lower 4-bits of ULAW_BYTE
yPBP#VAR1 = yEXPONENT * 2					' Build index to 16-bit table
wSAMPLE_ULAW = LRead8 exp_lut2[yPBP#VAR1]	' Read the sample from the table
yEXPONENT = yEXPONENT + 3
    wSAMPLE_ULAW = wSAMPLE_ULAW + (yMANTISSA << yEXPONENT)
    If yULAW_BYTE.7 = 1 Then                                           
    wSAMPLE_ULAW = -wSAMPLE_ULAW	' Test the sign bit of ULAW_BYTE
    EndIf
    If wSAMPLE_ULAW <= 32767 Then  ' POSITIVE
    wDA_OUT = wSAMPLE_ULAW + 32768
    Else   ' NEGITIVE
    wDA_OUT = wSAMPLE_ULAW - 32768
    EndIf
  ' NOW IS NON TWO'S COMP WORD


' UNCOMMENT LINE FOR DA(DIGITAL TO ANALOG) BIT SIZE IN USE        
' ULaw 8bit to 16bit DEcompressed
wDA_OUT = wDA_OUT / 256  'DOWNSAMPLE 16 BIT TO  8 BIT DA
'0000                                16 BIT TO 16 BIT DA

 
GoSub subWAIT_INTERRUPT

'GoSub subDA
'OR 
If dMEM_ADDRESS_READ < dEOF_ADDRESS - 1000 Then '-1000 ELIMINATE POP ON MICROSOFT SAM 
GoSub subDA                                          'ALSO MUST TRIM FLAT END OF FILE
EndIf                                            
  
If sPLAY_BUTTON = 0 Then
DelayMS 5    'DEBOUNCE
    If sPLAY_BUTTON = 0 Then
    While sPLAY_BUTTON = 0 : Wend
    GoTo STOP_PLAY
    EndIf
EndIf

Toggle sPC_FLOW_CTS  ' PC DETECT PIC

Inc dMEM_ADDRESS_READ
Until dMEM_ADDRESS_READ > dEOF_ADDRESS   ']]]]]]]]]]]]]

If iPLAY_ALL_SET = 1 And dFILE_PLAY < wFILES_TOTAL Then  'PLAY ALL
GoTo PLAY_ALL_NEXT    
EndIf
    
GoTo STOP_PLAY
'DONE MEM_CHIP_PLAY_ULAW:


'***********************************************
MEM_CHIP_PLAY_16BIT: 

iINTERRUPT_SET = 0         

Repeat  '[[[[[[[[[[[[ 

GoSub subCASCADE
         
GoSub subREAD_BYTES_ADDRESS                                           

SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE         
wDA_OUT.LowByte = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP 

SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
wDA_OUT.HighByte = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP 

GoSub subHI_CS 
                      

' UNCOMMENT LINE FOR DA(DIGITAL TO ANALOG) BIT SIZE IN USE          
wDA_OUT = wDA_OUT / 256  'DOWNSAMPLE 16 BIT TO  8 BIT DA
'0000                                16 BIT TO 16 BIT  


GoSub subWAIT_INTERRUPT

'GoSub subDA
'OR
If dMEM_ADDRESS_READ < dEOF_ADDRESS - 1500 Then '-1500 ELIMINATE POP ON MICROSOFT SAM 
GoSub subDA                                           'ALSO MUST TRIM FLAT END OF FILE
EndIf                                             
                                              
If sPLAY_BUTTON = 0 Then
DelayMS 5    'DEBOUNCE
    If sPLAY_BUTTON = 0 Then
    While sPLAY_BUTTON = 0 : Wend
    GoTo STOP_PLAY
    EndIf
EndIf

Toggle sPC_FLOW_CTS  ' PC DETECT PIC

dMEM_ADDRESS_READ = dMEM_ADDRESS_READ + 2
Until dMEM_ADDRESS_READ > dEOF_ADDRESS  ']]]]]]]]]]]]                                       

If iPLAY_ALL_SET = 1 And dFILE_PLAY < wFILES_TOTAL Then  'PLAY ALL
GoTo PLAY_ALL_NEXT    
EndIf
    
GoTo STOP_PLAY
'DONE MEM_CHIP_PLAY_16BIT:


'***********************************************
MEM_CHIP_PLAY_DATA: ' DATA FILE  'EXAMPLE: READS AND DISPLAYS NOTEPAD.TXT FILE 
                         
iINTERRUPT_SET = 0
 
Clear yARRAY65 
 
CONTINUE_PLAY_LOOP_DATA: '{{{{{{{{ 

y1 = 0
Repeat '[[[[[[[[[[[[

GoSub subCASCADE    

GoSub subREAD_BYTES_ADDRESS        
    
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
wDA_OUT = SSPBUF  ' READS 1 BYTE FROM MEMORY CHIP

GoSub subHI_CS
               
yARRAY65[y1] = wDA_OUT   'EXAMPLE: READS NOTEPAD.TXT FILE
 
If sPLAY_BUTTON = 0 Then
DelayMS 5    'DEBOUNCE
    If sPLAY_BUTTON = 0 Then
    While sPLAY_BUTTON = 0 : Wend
    GoTo STOP_PLAY
    EndIf
EndIf
       
If dMEM_ADDRESS_READ >= dEOF_ADDRESS Then
GoTo DATA_COMPLETED
EndIf

Inc dMEM_ADDRESS_READ
Inc y1
Until y1 = 64 ']]]]]]]]]]]]]]]

DATA_COMPLETED:

HSerOut[" ",13]
DelayMS 10

HSerOut [Str yARRAY65]    
Clear yARRAY65
DelayMS 10

HSerOut[" ",13]
DelayMS 10

If dMEM_ADDRESS_READ < dEOF_ADDRESS Then
GoTo CONTINUE_PLAY_LOOP_DATA '}}}}}}}
Else
    If iPLAY_ALL_SET = 1 And dFILE_PLAY < wFILES_TOTAL Then  'PLAY ALL
    GoTo PLAY_ALL_NEXT    
    EndIf
Inc dMEM_ADDRESS_READ     
GoTo STOP_PLAY
EndIf
'DONE MEM_CHIP_PLAY_DATA:


'***********************************************
subREAD_BYTES_ADDRESS:

' ADDRESS BITS 23 AND 24 (BITS > 4194303) IGNORED BY MEM CHIP  'FOR CHIPS 2-4

' READ DATA BYTES $03
         SSPBUF = $03 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ.BYTE2                    
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ.BYTE1
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ.BYTE0 
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         

Return

                              
'***********************************************
subWRITE_BYTES_ADDRESS:
                              
' PAGE_PROGRAM $02
      SSPBUF = $02 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_WRITE.BYTE2                    
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_WRITE.BYTE1
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_WRITE.BYTE0 
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF 

Return        


'***********************************************
subWAIT_INTERRUPT:

If iINTERRUPT_SET = 1 Then  'ERROR, LATE, INTERRUPT HAS OCCURRED 
Inc dLATE_FOR_PLAY_INTERRUPT
EndIf

PLAY_INTERUPT_LOOP:         ' LOOP TIL INTERRUPT
If iINTERRUPT_SET = 0 Then  ' INTERRUPT OCCURRED WHEN > 0
GoTo PLAY_INTERUPT_LOOP                        
EndIf
iINTERRUPT_SET = 0   

Return


'*********************************************** 
subDA:  ' COMMENT OUT FOR DA IN USE

    ' LTC1655L      ' 16 BIT DA  SOIC & DIP
    ' CLOCK PIN 2   ' PORTC.3 IS MICROCHIP SPI MSSP CLOCK
    ' DATA PIN 3    ' PORTC.5 IS MICROCHIP SPI MSSP DATA OUT 
    ' CHIP SELECT PIN 3

'    Low sDA_CS
'    SSPBUF = wDA_OUT.HighByte                    
'    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
'    yDUMMY = SSPBUF
    
'    SSPBUF = wDA_OUT.LowByte                    
'    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
'    yDUMMY = SSPBUF
'    High sDA_CS

''''''''''''''''''''''''''''''''''''''''''''''

    ' AD7303        ' 8 BIT DA  SOIC & DIP
    ' CLOCK PIN 5   ' PORTC.3 IS MICROCHIP SPI MSSP CLOCK
    ' DATA PIN 6    ' PORTC.5 IS MICROCHIP SPI MSSP DATA OUT 
    ' CHIP SELECT PIN 7
    
Low sDA_CS
SSPBUF = $30  '$30 = %00110000                 
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF

SSPBUF = wDA_OUT                   
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF
High sDA_CS

Return


'***********************************************
subCASCADE: 
    
Select dMEM_ADDRESS_READ.BYTE2  
Case < 64
Low sM25P32_MEM_CS_1                             

Case < 128
Low sM25P32_MEM_CS_2

Case < 192
Low sM25P32_MEM_CS_3

Case <= 255
Low sM25P32_MEM_CS_4
EndSelect

Return


'***********************************************
STOP_PLAY:          

T1CON.0 = 0   ' 0 = TIMER 1 OFF

If yFILE_TYPE = 3 Then  '= 3   16 BIT INC's BY 2
dMEM_ADDRESS_READ = dMEM_ADDRESS_READ - dSOF_PLAY_ADDRESS
dMEM_ADDRESS_READ  = dMEM_ADDRESS_READ / 2
HSerOut[13," WORDS PLAYED                                   LAST FILE = ",Dec dMEM_ADDRESS_READ,13]
Else
HSerOut[13," BYTES PLAYED                                     LAST FILE = ",Dec dMEM_ADDRESS_READ - dSOF_PLAY_ADDRESS,13] 
EndIf
                                                                                                                                                                      
HSerOut[" dLATE_FOR_PLAY_INTERRUPT ERRORS  ALL FILES = ",Dec dLATE_FOR_PLAY_INTERRUPT,13]
HSerOut[13," FILES_TOTAL = ",Dec wFILES_TOTAL,13]

GoSub subCLEAR_HSERIN_BUFFER
dLATE_FOR_PLAY_INTERRUPT = 0
dFILE_PLAY = -1
iPLAY_ALL_SET = 0
GoTo MAIN


'***********************************************        
subFILES_RECORDED_COUNT:

wFILE_COUNT = 0                            
iFILE_COUNT_DONE = 0

Repeat
Inc wFILE_COUNT

If wFILE_COUNT > 999 Then                   
HSerOut [13," FILE CONFIG NOT FOUND OR FILES > 1000 ***** ERASE MEMORY *****",13]

wFILES_TOTAL = 0
GoTo MEM_FAIL
EndIf

dMEM_ADDRESS_READ = sM25P32_MEM_MAX_BYTES_ADDRESS + 1        
dMEM_ADDRESS_READ = dMEM_ADDRESS_READ - (wFILE_COUNT * sFILE_INFO_BYTES)

' CASCADE
Select sMEM_CHIPS_TOTAL
Case 1 
yCHIP_SELECT = 1
Low sM25P32_MEM_CS_1 
Case 2 
yCHIP_SELECT = 2
Low sM25P32_MEM_CS_2
Case 3 
yCHIP_SELECT = 3
Low sM25P32_MEM_CS_3
Case 4 
yCHIP_SELECT = 4
Low sM25P32_MEM_CS_4 
EndSelect

GoSub subREAD_BYTES_ADDRESS    

For y1 = (sFILE_INFO_BYTES - 1) To 0 Step - 1
SSPBUF = yDUMMY
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
yARRAY65[y1] = SSPBUF         
Next

GoSub subHI_CS 

iFILE_COUNT_DONE = 1  'START
    For y1 = (sFILE_INFO_BYTES - 1) To 0 Step -1
        If yARRAY65[y1] <> 255 Then
        iFILE_COUNT_DONE = 0
        EndIf
    Next 
    
    If iFILE_COUNT_DONE = 1 Then
    wFILES_TOTAL = wFILE_COUNT - 1
    EndIf
Until iFILE_COUNT_DONE = 1  

HSerOut[" FILES_TOTAL = ",Dec wFILES_TOTAL,13]

Return
                                           

'***********************************************
subWRITE_STORED_FILEINFO:  '0 TO 4194303 LAST BYTE ON MEM

wFILES_TOTAL = wFILES_TOTAL + 1   'NEW FILE
dMEM_ADDRESS_WRITE = sM25P32_MEM_MAX_BYTES_ADDRESS - (wFILES_TOTAL * sFILE_INFO_BYTES) 
dMEM_ADDRESS_WRITE = dMEM_ADDRESS_WRITE + 1 '+1 IS FOR FIRST BYTE OF 23 BYTES OF FILEINFO

dMEM_ADDRESS_WRITE_START = dMEM_ADDRESS_WRITE

' TO START ADDRESS AT BEGINNIG OF SECTOR (NOT NECESSARILY REC START ADDRESS)
wTEMP = dMEM_ADDRESS_WRITE / 256    'wTEMP A WORD   NO DECIMAL POINT
dMEM_ADDRESS_WRITE = wTEMP * 256 


Select sMEM_CHIPS_TOTAL
Case 1
yCHIP_SELECT = 1                                 
Case 2
yCHIP_SELECT = 2
Case 3
yCHIP_SELECT = 3
Case 4 
yCHIP_SELECT = 4
EndSelect


GoSub subINSTRUCTIONS_WRITE_ENABLE

GoSub subLOW_CS  

GoSub subWRITE_BYTES_ADDRESS

yINC_0_to_63 = 0                    
yBUFFER_PT = 0

LOOP_0_to_4_LABEL2:  'If yINC_0_to_3 < 4 Then

LOOP_0_to_63_LABEL2: 'If yINC_0_to_63 < 64 Then

If dMEM_ADDRESS_WRITE < dMEM_ADDRESS_WRITE_START Then
    SSPBUF = %11111111 ' RECORD TO MEMORY CHIP 'DOES NOT CHANGE 0's TO 1's UNLESS ERASE
    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE     ' NO DATA CHANGE
    yDUMMY = SSPBUF
        
    Inc dMEM_ADDRESS_WRITE   
    Inc yINC_0_to_63

Else    
    
    If yBUFFER_PT = 0 And iSTORE_FILEINFO_DONE = 1 Then  'COMPLETE PAGE WITH $FF's
    For y1 = 0 To 63                           
    yARRAY65[y1] = $FF 
    Next   
    EndIf
        
    If yBUFFER_PT = 0 And iSTORE_FILEINFO_DONE = 0 Then
    iSTORE_FILEINFO_DONE = 1              ' ONE WRITE OF sFILE_INFO_BYTES BYTES
    
    ySOF_BYTE2 = dSOF_REC.BYTE2
    ySOF_BYTE1 = dSOF_REC.BYTE1                      
    ySOF_BYTE0 = dSOF_REC.BYTE0
    
    yEOF_BYTE2 = dEOF_REC.BYTE2
    yEOF_BYTE1 = dEOF_REC.BYTE1                      
    yEOF_BYTE0 = dEOF_REC.BYTE0
        
    
    yARRAY65[0] = yCONFIG
    yARRAY65[1] = ySOF_BYTE2
    yARRAY65[2] = ySOF_BYTE1
    yARRAY65[3] = ySOF_BYTE0
    
    yARRAY65[4] = yEOF_BYTE2
    yARRAY65[5] = yEOF_BYTE1
    yARRAY65[6] = yEOF_BYTE0 
     
    
    For y1 = 7 To 22                           
    yARRAY65[y1] = yARRAY_FILE_NAME16[y1 - 7] 
    Next              
    
    For y1 = 23 To 63                           
    yARRAY65[y1] = $FF 
    Next          

        
    EndIf
    
    yBYTE_FROM_PC = yARRAY65[yBUFFER_PT]
        
          
    SSPBUF = yBYTE_FROM_PC   ' RECORD TO MEMORY CHIP    'DATA
    While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
    yDUMMY = SSPBUF 
        
    Inc dMEM_ADDRESS_WRITE   
    
    Inc yINC_0_to_63
    Inc yBUFFER_PT
    
    If yBUFFER_PT = 64 Then
    yBUFFER_PT = 0
    EndIf
            
EndIf 

If yINC_0_to_63 < 64 Then  
GoTo LOOP_0_to_63_LABEL2
EndIf                                    

yINC_0_to_63 = 0 
 
Inc yINC_0_to_3 
If yINC_0_to_3 < 4 Then
GoTo LOOP_0_to_4_LABEL2
EndIf 
 
' 256 BYTE PAGE COMPLETED
 
GoSub subHI_CS  

wFILE_TO_READ_FILEINFO = wFILES_TOTAL
GoSub subREAD_STORED_FILEINFO

Return
' END OF subWRITE_STORED_FILEINFO

     
'***********************************************
subREAD_STORED_FILEINFO:

If wFILES_TOTAL > 0 Then
dMEM_ADDRESS_READ2 = sM25P32_MEM_MAX_BYTES_ADDRESS - (wFILE_TO_READ_FILEINFO * sFILE_INFO_BYTES)
dMEM_ADDRESS_READ2 = dMEM_ADDRESS_READ2 + 1 '+1 IS FOR FIRST BYTE OF 23 BYTES
DelayMS 10  'REQUIRED
Else
dEOF_ADDRESS = -1
Return
EndIf                                        
      
' CASCADE
Select sMEM_CHIPS_TOTAL
Case 1 
Low sM25P32_MEM_CS_1 
Case 2 
Low sM25P32_MEM_CS_2
Case 3 
Low sM25P32_MEM_CS_3
Case 4 
Low sM25P32_MEM_CS_4  
EndSelect    

' READ DATA BYTES $03
         SSPBUF = $03 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ2.BYTE2                    
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ2.BYTE1
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF         
SSPBUF = dMEM_ADDRESS_READ2.BYTE0 
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF  
                            

SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
yCONFIG = SSPBUF


dMEM_ADDRESS_READ.BYTE3 = 0
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dMEM_ADDRESS_READ.BYTE2 = SSPBUF         
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dMEM_ADDRESS_READ.BYTE1  = SSPBUF 
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dMEM_ADDRESS_READ.BYTE0 = SSPBUF           


dEOF_ADDRESS.BYTE3 = 0
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dEOF_ADDRESS.BYTE2 = SSPBUF         
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dEOF_ADDRESS.BYTE1  = SSPBUF 
SSPBUF = $FF
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE    
dEOF_ADDRESS.BYTE0 = SSPBUF  

Clear yARRAY_FILE_NAME16
For y1 = 0 To 15
SSPBUF = yDUMMY
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE     
yARRAY_FILE_NAME16[y1] = SSPBUF    
Next                            
    
GoSub subHI_CS      


If dEOF_ADDRESS = 16777215 Then   ' 16777215 = %111111111111111111111111
HSerOut [" ERROR!  INCORRECT READ OF FILES TOTAL",13] 

HSerOut[" RESET MICROCHIP",13]

yBYTE_FROM_PC = 0

y1 = 0
MEM_FAIL_LOOP2:

High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 1000,EXIT_HSERIN_MEM_FAIL2,[yBYTE_FROM_PC]   
EXIT_HSERIN_MEM_FAIL2:
Low sPC_FLOW_CTS       ' BLOCK  PC To Send 

    If yBYTE_FROM_PC = 210 Then
    HSerOut[13," RECEIVED RESET CMD",13]
    DelayMS 100
    reset
    EndIf 
    
    Inc y1
    If y1 = 70 Then
    y1 = 0
    HSerOut["/",13]
    Else
    HSerOut["/"]
    EndIf

GoTo MEM_FAIL_LOOP2    

EndIf

Return


'***********************************************
BULK_ERASE:  

yCHIP_SELECT = 0
iERASE_SET = 1

LOOP_ERASE:
Inc yCHIP_SELECT
HSerOut[13," START BULK ERASE CHIP ",Dec yCHIP_SELECT," OF ",Dec sMEM_CHIPS_TOTAL,13]
GoSub subINSTRUCTIONS_WRITE_ENABLE            
GoSub subLOW_CS
SSPBUF = $C7 ' SEND DATA BYTE
While SSPSTAT.0 = 0: Wend ' WHILE TX/RX COMPLETE
yDUMMY = SSPBUF
GoSub subHI_CS
yDOT_COUNT = 0
GoSub subREAD_STATUS_REGISTER  ' POLL FOR COMPLETE  34 TO 80 SECONDS
 
If yCHIP_SELECT = sMEM_CHIPS_TOTAL Then
HSerOut[13," BULK ERASE CHIP 1 TO ",Dec sMEM_CHIPS_TOTAL," COMPLETE",13]

GoSub subCLEAR_HSERIN_BUFFER

GoTo BEGINNING_OF_DIMS
Else
GoTo LOOP_ERASE
EndIf
  

'***********************************************
subCLEAR_HSERIN_BUFFER:  

For y1 = 1 To 3
yBYTE_FROM_PC = 0
High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 100,TIMEDOUT_HSERIN1,[yBYTE_FROM_PC]   ' RECEIVE DATA
Low sPC_FLOW_CTS       ' BLOCK  PC To Send
DelayMS 50 ' RE
TIMEDOUT_HSERIN1:
Next

Return



'*********************************************** 
'***********************************************
'***********************************************
'***********************************************

START:

DelayMS 500 
HSerOut[13," ***************************",13]   
HSerOut[" START",13] 
                            
GoTo READ_ID  ' VERIFY MEMORY OK
RETURN_FROM_READ_ID:
GoSub subREAD_STATUS_REGISTER
GoSub subFILES_RECORDED_COUNT ' RETURNS wFILES_TOTAL                                                                                        
GoSub subREAD_STATUS_REGISTER

'HSerOut[13," NEXT 4 LINES ONLY: BYTES TOTAL(1to ) NOT ADDRESS(0to )",13]
HSerOut[" ",13]

''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA
HSerOut[" ",DEC8 sM25P32_MEM_CAP_BYTES," = MEMORY CAP",13]

' TO DETERMINE BYTES REMAINING
wFILE_TO_READ_FILEINFO = wFILES_TOTAL
GoSub subREAD_STORED_FILEINFO   ' DETERMINE dEOF_ADDRESS FOR LAST FILE 
GoSub subREAD_STATUS_REGISTER 

dM25P32_MEM_MAX_ADDRESS_AVAIL = sM25P32_MEM_MAX_BYTES_ADDRESS - (sFILE_INFO_BYTES * 2) 
'-46 = - sFILE_INFO_BYTES(23 BYTES) Next FILE &
'-sFILE_INFO_BYTES(23 BYTES)to be left all 1's AS BUFFER BETWEEN FILE INFO & DATA
dM25P32_MEM_MAX_ADDRESS_AVAIL = dM25P32_MEM_MAX_ADDRESS_AVAIL - (wFILES_TOTAL * sFILE_INFO_BYTES)


If dM25P32_MEM_MAX_ADDRESS_AVAIL > dEOF_ADDRESS Then  'MEMORY NOT MAXED OUT  

    ''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA        
        HSerOut[" ",DEC8 dM25P32_MEM_MAX_ADDRESS_AVAIL+1," = MAX AVAIL",13]
                                                   ' + 1 INCLUDE 0                                                        
    If wFILES_TOTAL = 0 Then   
    ''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA 
        HSerOut[" 00000000 = MEMORY USED 0%",13]                       
    Else
         'ROUND UP
         dMEMORY_USED_PER_CENT = dEOF_ADDRESS * 100
         dMEMORY_USED_PER_CENT = dMEMORY_USED_PER_CENT / (dM25P32_MEM_MAX_ADDRESS_AVAIL / 10)
         dMEMORY_USED_PER_CENT = (dMEMORY_USED_PER_CENT + 5) / 10
        
    ''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA       
        HSerOut[" ",DEC8 dEOF_ADDRESS+1," = MEMORY USED ",Dec dMEMORY_USED_PER_CENT,"%",13]
                                       ' +1 FOR BYTES TOTAL  INCLUDE 0                               
    EndIf    
       dBYTES_REMAINING = dM25P32_MEM_MAX_ADDRESS_AVAIL - dEOF_ADDRESS    
                                      
         'ROUND UP
         dBYTES_REMAINING_PER_CENT = dBYTES_REMAINING * 100
         dBYTES_REMAINING_PER_CENT = dBYTES_REMAINING_PER_CENT / (dM25P32_MEM_MAX_ADDRESS_AVAIL / 10)
         dBYTES_REMAINING_PER_CENT = (dBYTES_REMAINING_PER_CENT + 5) / 10
      
         HSerOut[" ",DEC8 dBYTES_REMAINING," = BYTES REMAINING ",Dec dBYTES_REMAINING_PER_CENT,"%",13,13]
       
       
       If dMEMORY_USED_PER_CENT + dBYTES_REMAINING_PER_CENT <> 100 Then
       HSerOut["PERCENT ERROR**************",13]
       EndIf

    
Else ' MEMORY MAXED OUT                
         
    ''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA   
        HSerOut[" ",DEC8 dM25P32_MEM_MAX_ADDRESS_AVAIL+1," = Max AVAIL",13]
                                                   ' + 1 INCLUDE 0
        
    ''''PROTECTED STATMENT  DO NOT ALTER  PC READS TO INITIALIZE DATA   
        HSerOut[" ",DEC8 dEOF_ADDRESS+1," = MEMORY USED ",Dec (dEOF_ADDRESS * 100) / dM25P32_MEM_MAX_ADDRESS_AVAIL,"%",13]
                                        ' +1 FOR BYTES TOTAL  INCLUDE 0   
             
        
        HSerOut[" MEMORY MAXED OUT",13] 
       
    iMEM_MAXED_OUT_SET = 1                                       
EndIf


 

MAIN:



    
''''' TEST IN_PROGRAM_FILE_PLAY ''''' PLAYS 1 FILE 
'iIN_PROGRAM_FILE_PLAY_SET = 1
'wIN_PROG_FILE_TO_PLAY = 2

If iIN_PROGRAM_FILE_PLAY_SET = 1 Then
iIN_PROGRAM_FILE_PLAY_SET = 0
dFILE_PLAY = wIN_PROG_FILE_TO_PLAY 

    If dFILE_PLAY > wFILES_TOTAL Then
    HSerOut[" Exceded Files Available",13]
    dFILE_PLAY = -1
    GoTo MAIN
    EndIf 

    If dFILE_PLAY > 0 Then      
    wFILE_TO_READ_FILEINFO = wIN_PROG_FILE_TO_PLAY
    GoSub subREAD_STORED_FILEINFO
    HSerOut [13,"INPROG PLAYING FILE ",Dec wIN_PROG_FILE_TO_PLAY,", ["]
        For y1 = 0 To 15
        HSerOut [yARRAY_FILE_NAME16[y1]]
        Next   
    HSerOut ["] Press Play To Stop",13]
    GoTo PLAY_FILE  
    EndIf
EndIf
''''' END IN_PROGRAM_FILE_PLAY ''''  






' PUSHBUTTON & PC COMMANDS
'''''''''''''''''''''''''''''''''''''''''''''
yBYTE_FROM_PC = 0

High sPC_FLOW_CTS       ' Clear  PC To Send
HSerIn 100,EXIT_HSERIN,[yBYTE_FROM_PC]   ' RECEIVE DATA
Low sPC_FLOW_CTS       ' BLOCK  PC To Send
DelayMS 50 ' REQUIRED FOR PC PULSE DETECTOR  
    
'RECORD MEMORY CHIP    
If yBYTE_FROM_PC = $53 Then   '83 = "S"send = $53
    If iMEM_MAXED_OUT_SET = 1 Then  ' 1 = MAXED
    HSerOut[" REC COMMAND RECEIVED HOWEVER MEMORY MAXED OUT",13]
    HSerOut[" > ",Dec sFILE_INFO_BYTES," BYTES REQUIRED FOR A FILE",13]
    GoTo EXIT_HSERIN
    EndIf                   

''''PROTECTED STATMENT  DO NOT ALTER  PC READS BEFORE SENDING DATA   
 HSerOut[13," PIC RECEIVED REC CMD",13] 
                
GoTo MEM_CHIP_RECORD                       
EndIf
  
''''''''''''''''''''''''''
' DELETE MEMORY CHIP     
If yBYTE_FROM_PC = $44 Then   '68 = "D"delete = $44     
HSerOut[13," RECEIVED DELETE CMD",13]
GoTo BULK_ERASE
EndIf
  
''''''''''''''''''''''''''
' RESET PIC CMD
If yBYTE_FROM_PC = $D2 Then   '210 = $D2
HSerOut[13," RECEIVED RESET CMD,  INITIALIZE DATA",13]
DelayMS 100
reset
EndIf 

If yBYTE_FROM_PC <> 0 Then  'INVALID COMMAND
HSerOut[" INVALID COMMAND [$",HEX2 yBYTE_FROM_PC,"]  DELAY TO TIME OUT",13]
HSerOut[" VALID COMMANDS ARE: REC $53, DELETE $44, RESET $D2",13]
Low sPC_FLOW_CTS  ' BLOCK  PC To Send
DelayMS 50 ' REQUIRED FOR PC PULSE DETECTOR   
 
DelayMS 4000
EndIf
 
EXIT_HSERIN:
Low sPC_FLOW_CTS  ' BLOCK  PC To Send
DelayMS 50 ' REQUIRED FOR PC PULSE DETECTOR   


''''''''''''''''''''''''''
If sPLAY_BUTTON = 1 Then
iPLAY_ENABLED = 1   ' MUST BE OFF BEFORE PLAY AGAIN
EndIf

If sPLAY_BUTTON = 0 And iPLAY_ENABLED = 1 Then
    If wFILES_TOTAL = 0 Then
    HSerOut["  0 FILES",13]
    GoTo MAIN
    EndIf 
    
    INC_FILE:    
    Inc dFILE_PLAY    

    If dFILE_PLAY > wFILES_TOTAL Then
    HSerOut[" Exceded Files Available",13]
    dFILE_PLAY = -1
    While sPLAY_BUTTON = 0 : Wend
    DelayMS 100
    GoTo MAIN
    EndIf 
    
    If dFILE_PLAY = 0 Then
    HSerOut["  PLAY ALL FILES,    Press Again OR Hold Down To Advance",13]
    EndIf
    
    If dFILE_PLAY > 0 Then
    
    wFILE_TO_READ_FILEINFO = dFILE_PLAY
    GoSub subREAD_STORED_FILEINFO
    GoSub subREAD_STATUS_REGISTER 
    
    GoSub subREAD_STORED_FILEINFO
    
    HSerOut["  PLAY FILE ",Dec dFILE_PLAY ,", ["]             
                For y1 = 0 To 15
                HSerOut [yARRAY_FILE_NAME16[y1]]
                Next                              
    HSerOut["]  Press/Hold To Advance",13] 
    
    EndIf        
    
    
                    
    yNOHOLD_COUNT = 0
    yHOLD_COUNT = 0
    
    BUTTON_HOLD_LOOP:
    Toggle sPC_FLOW_CTS  ' PC DETECT PIC     
    If sPLAY_BUTTON = 0 Then
    yNOHOLD_COUNT = 0
    DelayMS 1
    Inc yHOLD_COUNT    
        If yHOLD_COUNT > 250 Then
        GoTo INC_FILE
        EndIf       
    Else
    yHOLD_COUNT = 0
    DelayMS 3
    Inc yNOHOLD_COUNT        
        If yNOHOLD_COUNT > 20 Then
        wNOPRESS_COUNT = 0
        GoTo BUTTON_PRESS_LOOP
        EndIf
    EndIf
    
    GoTo BUTTON_HOLD_LOOP
    
    BUTTON_PRESS_LOOP:
    Toggle sPC_FLOW_CTS  ' PC DETECT PIC     
    If sPLAY_BUTTON = 0 Then
    GoTo INC_FILE
    Else
    DelayMS 3
    Inc wNOPRESS_COUNT
        If wNOPRESS_COUNT > 1000 Then
        GoTo MENU_DONE_NOW_PLAY
        EndIf
    GoTo BUTTON_PRESS_LOOP 
    EndIf  

    dLATE_FOR_PLAY_INTERRUPT = 0
''''''''''''''''''''''''''''' 
  MENU_DONE_NOW_PLAY: 
    
    If dFILE_PLAY = 0 Then  ' READ ALL
    wFILE_TO_READ_FILEINFO = 0 
    iPLAY_ALL_SET = 1 
    
    PLAY_ALL_NEXT:  'RETURNS FROM END OF PLAY WHEN PLAY ALL  
    dFILE_PLAY = dFILE_PLAY + 1
    wFILE_TO_READ_FILEINFO = dFILE_PLAY          
    GoSub subREAD_STORED_FILEINFO         
    HSerOut[13," PLAYING ALL, FILE ",Dec dFILE_PLAY ,", ["]             
                For y1 = 0 To 15
                HSerOut [yARRAY_FILE_NAME16[y1]]
                Next                              
    HSerOut["] Press Play to Stop",13]
    
    Else
    
    GoSub subREAD_STORED_FILEINFO
    HSerOut ["                                              Press Play To Stop",13]
    EndIf  
        
    PLAY_FILE:
     
     
    GoTo DECODE_CONFIG_BYTE
    RETURN_FROM_DECODE_CONFIG_BYTE:
        
        
    If yFILE_TYPE <> 4 Then   'NOT DATA            
    T1CON.0 = 0   ' 0 = TIMER 1 OFF    ' SHOULD BE OFF AT STOP PLAY AND FILE CONFIG
    wTIMER1 = dTimerPreload
    T1CON.0 = 1   ' 1 = TIMER 1 ON
    EndIf    
    
            
    Select yFILE_TYPE 
    Case = 0 ' ADPCM COMPRESSION
    GoTo MEM_CHIP_PLAY_ADPCM
    
    Case = 1  '8 BIT                                               
    GoTo MEM_CHIP_PLAY_8BIT  
             
    Case = 2 'ULAW COMPRESSION
    GoTo MEM_CHIP_PLAY_ULAW
    
    Case = 3  '16 BIT              
    GoTo MEM_CHIP_PLAY_16BIT  
    
    Case = 4  'DATA 
    GoTo MEM_CHIP_PLAY_DATA   
    EndSelect 
            
EndIf    
            
GoTo MAIN
            
End



